<?php
    
    include('../../../datab.php');
    
    include "../../../fcm/get_access_token.php";
    
    $access_token = get_access_token("../../../fcm/used-cars-zapcars-firebase-adminsdk-fbsvc-afe16684b9.json");
    
    function sendFCMNotification($access_token, $token, $content, $img_path) 
    {
        $url = "https://fcm.googleapis.com/v1/projects/used-cars-zapcars/messages:send";
        $data = [
            'message' => [
                "data"=> [
                    "title" => "Car Update",
                    "body" => $content,
                    "type" => "Car Rejected",
                    "color" => "#FF0000"
                ],
                'notification' => [
                    "title" => "Car Update",
                    "body" => $content,
                    "image" => $img_path
                ],
                'token' => $token,
                'android' => [
                    'notification' => [
                        'channel_id' => 'Car Rejected',
                        'image' => $img_path
                    ]
                ],
                'apns' => [
                    'payload' => [
                        'aps' => [
                            'mutable-content' => 1,
                        ],
                    ],
                    'fcm_options' => [
                        'image' => $img_path
                    ]
                ]
    
            ]
        ];
    
        $options = array(
            CURLOPT_URL => $url,
            CURLOPT_POST => true,
            CURLOPT_HTTPHEADER => array(
                "Authorization: Bearer " . $access_token,
                "Content-Type: application/json",
            ),
            CURLOPT_POSTFIELDS => json_encode($data),
        );
    
        $curl = curl_init();
        curl_setopt_array($curl, $options);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        $response = curl_exec($curl);
        curl_close($curl);
    
        return $response;
    }
    
    $sql = "SELECT * FROM master_dealer_notification_category where category_name = 'Car' AND status = 'Active' ";
    $rec = mysqli_query($conn, $sql);
    if($data = mysqli_fetch_assoc($rec))
    {
        $dealer_cat_id = $data['id'];
    }
    else
    {
        $dealer_cat_id = 0;
    }
    
    $car_enc_key = mysqli_real_escape_string($conn, $_POST['car_id']);
    
    $sql = "SELECT car_data.id as car_id, car_no_data.reg_no, api_old_car_info.brand_model as model_name,
                            api_old_car_info.brand_name as brand_name, car_data.car_no_id, car_data.posted_dealer_id
                    FROM car_data, car_no_data, api_old_car_info
                    where car_data.status = 'Pending'
                        and car_data.enc_key = '$car_enc_key'
                        and car_data.car_no_id = car_no_data.id
                        and api_old_car_info.id = car_data.car_api_id
                    LIMIT 1";
    $rec = mysqli_query($conn, $sql);
    if($data = mysqli_fetch_assoc($rec))
    {
        $car_id = $data['car_id'];
        $car_no_id = $data['car_no_id'];
        $dealer_id = $data['posted_dealer_id'];
        
        $content = $data['reg_no'].' ('.$data['model_name'].' '.$data['brand_name'].' ) is Rejected.';
        
        $sql = "UPDATE car_data SET status = 'Rejected' WHERE id = '$car_id' ";
        mysqli_query($conn, $sql);
        
        $sql = "SELECT * FROM dealer_user where dealer_id = '$dealer_id' AND status = 'Active' ";
        $rec = mysqli_query($conn, $sql);
        while($data = mysqli_fetch_assoc($rec))
        {
            $trigger_user_id = $data['id'];
            
            $sql = "INSERT INTO dealer_notification (`dealer_user_id`, `category`, `content`, `read_status`, `status`, `dateTime`) 
                            VALUES ('$trigger_user_id', '$dealer_cat_id', '$content' , '0', 'Active' , '$dateTime')";
            mysqli_query($conn, $sql);
            
            $sql = "UPDATE dealer_user SET new_notification = '1' WHERE id = '$trigger_user_id' ";
            mysqli_query($conn, $sql);
            
            $sql = "SELECT * FROM dealer_user_notification_token where dealer_user_id = '$trigger_user_id' AND status = 'Active' ";
            $notification_rec = mysqli_query($conn, $sql);
            while($notification_data = mysqli_fetch_assoc($notification_rec))
            {
                $user_token[] = $notification_data['token_no'];
            }
            
        }
        
        $sql = "SELECT * FROM car_image_data WHERE view_id = '4' and car_id = '$car_id' and status = 'Active' ";
        $rec = mysqli_query($conn, $sql);
        if($data = mysqli_fetch_assoc($rec))
        {
            $img_path = $domain.'assets/car_images/'.$car_enc_key.'/'.$data['file_name'];
        }
        
        foreach ($user_token as $token) {
            $response = sendFCMNotification($access_token, $token, $content, $img_path);
        }
        
        $res['status'] = 'Success';
        $res['remarks'] = 'Car Reject.';
    }
    else
    {
        $res['status'] = 'No Data';
        $res['remarks'] = 'Car Not Found.';
    }
    
    echo json_encode($res);
?>