<?php include '../path.php'; ?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no">
    <title>HexaDash | Brand List </title>
<!-- Favicon -->
<link rel="icon" type="image/x-icon" href="https://designreset.com/cork/html/src/assets/img/favicon.ico"/>

<!-- Loader CSS -->
<link href="../layouts/modern-dark-menu/css/light/loader.css" rel="stylesheet" type="text/css" />
<link href="../layouts/modern-dark-menu/css/dark/loader.css" rel="stylesheet" type="text/css" />
<script src="../layouts/modern-dark-menu/loader.js"></script>

<!-- BEGIN GLOBAL MANDATORY STYLES -->
<link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700" rel="stylesheet">
<link href="../src/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
<link href="../layouts/modern-dark-menu/css/light/plugins.css" rel="stylesheet" type="text/css" />
<link href="../layouts/modern-dark-menu/css/dark/plugins.css" rel="stylesheet" type="text/css" />
<!-- END GLOBAL MANDATORY STYLES -->

<!-- BEGIN PAGE LEVEL STYLES -->
<link rel="stylesheet" type="text/css" href="../src/plugins/src/table/datatable/datatables.css">
<link rel="stylesheet" type="text/css" href="../src/plugins/css/light/table/datatable/dt-global_style.css">
<link rel="stylesheet" type="text/css" href="../src/plugins/css/dark/table/datatable/dt-global_style.css">
<!-- END PAGE LEVEL STYLES -->

<!-- BEGIN PAGE LEVEL PLUGINS -->
<link href="../src/plugins/src/animate/animate.css" rel="stylesheet" type="text/css" />
<!-- END PAGE LEVEL PLUGINS -->

<!-- BEGIN CUSTOM STYLE FILES -->
<link href="../src/assets/css/light/scrollspyNav.css" rel="stylesheet" type="text/css" />
<link href="../src/assets/css/light/components/carousel.css" rel="stylesheet" type="text/css">
<link href="../src/assets/css/light/components/modal.css" rel="stylesheet" type="text/css" />
<link href="../src/assets/css/light/components/tabs.css" rel="stylesheet" type="text/css">

<link href="../src/assets/css/dark/scrollspyNav.css" rel="stylesheet" type="text/css" />
<link href="../src/assets/css/dark/components/carousel.css" rel="stylesheet" type="text/css">
<link href="../src/assets/css/dark/components/modal.css" rel="stylesheet" type="text/css" />
<link href="../src/assets/css/dark/components/tabs.css" rel="stylesheet" type="text/css">
<!-- END CUSTOM STYLE FILES -->

<!-- BEGIN FILEPOND STYLES -->
<link rel="stylesheet" href="../src/plugins/src/filepond/filepond.min.css">
<link rel="stylesheet" href="../src/plugins/src/filepond/FilePondPluginImagePreview.min.css">    
<link href="../src/plugins/css/light/filepond/custom-filepond.css" rel="stylesheet" type="text/css" />
<link href="../src/plugins/css/dark/filepond/custom-filepond.css" rel="stylesheet" type="text/css" />
<!-- END FILEPOND STYLES -->

    <!-- END PAGE LEVEL STYLES -->
</head>
<body class="layout-boxed">
    <!-- BEGIN LOADER -->
    <div id="load_screen"> <div class="loader"> <div class="loader-content">
        <div class="spinner-grow align-self-center"></div>
    </div></div></div>
    <!--  END LOADER -->

    <!--  BEGIN NAVBAR  -->
    <?php include 'top_menu.php'; ?>
    <!--  END NAVBAR  -->
    <!--  BEGIN MAIN CONTAINER  -->
    <div class="main-container " id="container">

        <div class="overlay"></div>
        <div class="cs-overlay"></div>
        <div class="search-overlay"></div>

        <!--  BEGIN SIDEBAR  -->
        <?php include 'Sidebar.php'; ?>
        <!--  END SIDEBAR  -->

        <!--  BEGIN CONTENT AREA  -->
        <div id="content" class="main-content">
            <div class="layout-px-spacing">

                <div class="middle-content container-xxl p-0">
                    
                    <!-- BREADCRUMB -->
                    <div class="page-meta">
                        <nav class="breadcrumb-style-one" aria-label="breadcrumb">
                            <ol class="breadcrumb">
                               <h5 class="mb-0">Brand List</h5>
                            </ol>
                        </nav>
                    </div>
                    <!-- /BREADCRUMB -->
    
                    <div class="row layout-top-spacing">
                    
                        <div class="col-xl-12 col-lg-12 col-sm-12  layout-spacing">
                            <div class="widget-content widget-content-area br-8">
                                <table id="zero-config" class="table dt-table-hover" style="width:100%">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Brand Name</th>
                                            <th>No of Models</th>
                                            <th>Created By</th>
                                            <th>Created On</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody  id="brand_list">
                                        <tr>
                                        <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                        
                                    </tbody>
                                    <tfoot>
                                        <tr>
                                            <th>#</th>
                                            <th>Brand Name</th>
                                            <th>No of Models</th>
                                            <th>Created By</th>
                                            <th>Created On</th>
                                            <th>Action</th>
                                        </tr>
                                    </tfoot>
                                </table>
                            </div>
                        </div>
    
                    </div>
    
                </div>
                
            </div>
            
            <!--  BEGIN FOOTER  -->
            <div class="footer-wrapper mt-0">
                <div class="footer-section f-section-1">
                   <p><span>© 2025</span><a href="#" class="text-secondary">Cryptographic Solutions</a></p>
                </div>
                <div class="footer-section f-section-2">
                    <p class="">Coded with <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-heart"><path d="M20.84 4.61a5.5 5.5 0 0 0-7.78 0L12 5.67l-1.06-1.06a5.5 5.5 0 0 0-7.78 7.78l1.06 1.06L12 21.23l7.78-7.78 1.06-1.06a5.5 5.5 0 0 0 0-7.78z"></path></svg></p>
                </div>
            </div>
            <!--  END CONTENT AREA  -->
        </div>
        <!--  END CONTENT AREA  -->
    </div>
    <!-- END MAIN CONTAINER -->
                            <div id="add_brand_modal" class="modal animat   ed fadeInUp custo-fadeInUp" role="dialog">
                                <div class="modal-dialog">
                                    <!-- Modal content-->
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title">Create Brand</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
                                              <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-x"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg>
                                            </button>
                                        </div>
                                        <div class="modal-body">
                                            <lable class="form-lable mb-2">Brand Name</lable>
                                                <input type="text" id="new_brand_name" placeholder="Hyundai" class="form-control mb-3"></input>
                                            <lable class="form-lable mb-2">Brand Logo</lable>
                                            <div class="mb-3">
                                                <input type="file" id="new_logo" placeholder="Hyundai" class="form-control file-upload-input">
                                            </div>
                                            </div>
                                        <div class="modal-footer md-button">
                                            <button class="btn btn-light-danger" data-bs-dismiss="modal">Discard</button>
                                            <button type="button" id="create_new_brand" class="btn btn-secondary">Create</button>
                                        </div>
                                    </div>
                                </div>
                            </div>
<!-- BEGIN GLOBAL MANDATORY SCRIPTS -->
<script src="<?php echo $main_path; ?>src/plugins/src/global/vendors.min.js"></script>
<script src="<?php echo $main_path; ?>src/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="<?php echo $main_path; ?>src/plugins/src/perfect-scrollbar/perfect-scrollbar.min.js"></script>
<script src="<?php echo $main_path; ?>src/plugins/src/mousetrap/mousetrap.min.js"></script>
<script src="<?php echo $main_path; ?>src/plugins/src/waves/waves.min.js"></script>
<!-- <script src="<?php echo $main_path; ?>layouts/modern-dark-menu/app.js"></script> -->
<script src="<?php echo $main_path; ?>src/assets/js/custom.js"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.css">
<script src="//cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<!-- END GLOBAL MANDATORY SCRIPTS -->

<!-- BEGIN PAGE LEVEL SCRIPTS -->
<script src="<?php echo $main_path; ?>src/plugins/src/table/datatable/datatables.js"></script>
<script src="<?php echo $main_path; ?>src/plugins/src/highlight/highlight.pack.js"></script>

<!-- FilePond Plugins -->
<script src="<?php echo $main_path; ?>src/plugins/src/filepond/filepond.min.js"></script>
<script src="<?php echo $main_path; ?>src/plugins/src/filepond/FilePondPluginFileValidateType.min.js"></script>
<script src="<?php echo $main_path; ?>src/plugins/src/filepond/FilePondPluginImageExifOrientation.min.js"></script>
<script src="<?php echo $main_path; ?>src/plugins/src/filepond/FilePondPluginImagePreview.min.js"></script>
<script src="<?php echo $main_path; ?>src/plugins/src/filepond/FilePondPluginImageCrop.min.js"></script>
<script src="<?php echo $main_path; ?>src/plugins/src/filepond/FilePondPluginImageResize.min.js"></script>
<script src="<?php echo $main_path; ?>src/plugins/src/filepond/FilePondPluginImageTransform.min.js"></script>
<script src="<?php echo $main_path; ?>src/plugins/src/filepond/filepondPluginFileValidateSize.min.js"></script>

<!-- Custom Scripts -->
<script src="<?php echo $main_path; ?>src/assets/js/scrollspyNav.js"></script>

        <script>
                $(document).ready(function () {
                    var table = $('#zero-config').DataTable({
                        dom: "<'dt--top-section'<'row align-items-center'<'col-12 col-sm-6 custom-search text-sm-start'><'col-12 col-sm-6 dt-title text-sm-end'>>" +
                             "<'table-responsive'tr>",
                        oLanguage: {
                            sInfo: "",
                            sLengthMenu: ""
                        },
                        stripeClasses: [],
                        paging: false // no pagination
                    });
                
                    // Add search box (left)
                    $("div.custom-search").html(
                        '<input type="text" id="search_key" class="form-control w-auto d-inline-block mb-2" placeholder="Search...">'
                    );
                
                    // Add button (right)
                    $("div.dt-title").html(
                        '<button type="button" class="btn btn-success mb-2" data-bs-toggle="modal" data-bs-target="#add_brand_modal">Add Brand</button>'
                    );
                
                    // Bind search
                    $(document).on('keyup', '#search_key', function () {
                        table.search(this.value).draw();
                    });
                });
        </script>

    
    <script>
    $(document).ready(function() 
    {
      function getBrands()
      {
        var search_key = $('#search_key').val();

        var fd = new FormData();
        fd.append('search_key',search_key);
        
        $.ajax({
          type: "POST",
          url: "<?php echo $admin_path; ?>ajax/brand/brand_list.php",
          data: fd,
          processData: false,
          contentType: false,
          success: function(response)
          {
            $('#brand_list').html('');
            var result = JSON.parse(response);
            if(result.status == 'Success')
            {
              $.each(result.data, function(key, value)
              {
                model_location = 'Model-List?brand_id='+value.brand_id;
                $('#brand_list').append(`<tr data-brand-id="${value.brand_id}">
                                            <td>${key+1}.</td>
                                            <td>
                                              <div class="d-flex align-items-center gap-2">
                                              <img src="${value.logo}" alt="${value.logo}" class="rounded-circle" width="30" height="30">
                                              ${value.brand_name}
                                              </div>
                                            </td>
                                            <td style="cursor:pointer;" onclick="location.href='${model_location}'">${value.model_count} Nos</td>
                                            <td>${value.created_by}</td>
                                            <td>${value.created_on}</td>
                                            <td>
                                              <button class="btn btn-sm btn-danger remove_brand">x</button>
                                            </td>
                                          </tr>`);
              });
            }
            
          }
        });
      }

      getBrands();

      $('#search_key').keyup(function()
      {
        getBrands();
      })

      $('#create_new_brand').click(function()
      {
        var brand_name = $('#new_brand_name').val();
        var brand_logo_name = $('#new_logo').val();
        var brand_logo = $('#new_logo')[0].files[0];

        if(brand_name == '')
        {
          toastr.error('Brand Name not mentioned.');
        }
        else if(brand_logo_name == '')
        {
          toastr.error('Brand Logo not selected.');
        }
        else 
        {
          var fd = new FormData();
          fd.append('brand_name',brand_name);
          fd.append('brand_logo',brand_logo);
          
          $.ajax({
            type: "POST",
            url: "<?php echo $admin_path; ?>ajax/brand/brand_creation.php",
            data: fd,
            processData: false,
            contentType: false,
            success: function(response)
            {
              var result = JSON.parse(response);

              if(result.status == 'Success')
              {
                                 $('#add_brand_modal').modal('hide');

                toastr.success('Brand Added Successfully.');
                getBrands();
              }
              else if(result.status == 'Photo not Uploaded')
              {
                  toastr.error('Error uploading Logo.');
              }
              else if(result.status == 'Available')
              {
                  toastr.error('Brand Already Exist.');
              }
            }
          })
        }
        
      })

      $('#brand_list').on('click','.remove_brand',function()
      {
        var brand_id = $(this).closest('tr').data('brand-id');

        var fd = new FormData();
          fd.append('brand_id',brand_id);
          
          $.ajax({
            type: "POST",
            url: "<?php echo $admin_path; ?>ajax/brand/brand_remove.php",
            data: fd,
            processData: false,
            contentType: false,
            success: function(response)
            {
              var result = JSON.parse(response);

              if(result.status == 'Success')
              {
                toastr.success('Brand Removed Successfully.');
                getBrands();
              }
              else
              {
                  toastr.error('Error with the backend.');
              }
            }
          })

      })

    });

  </script>
    <!-- END PAGE LEVEL SCRIPTS -->
</body>

</html>