<?php include('path.php'); ?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, shrink-to-fit=no">
    <title>HexaDash | Login </title>
    <link rel="icon" type="image/x-icon" href="https://designreset.com/cork/html/src/assets/img/favicon.ico"/>
    <link href="layouts/modern-dark-menu/css/light/loader.css" rel="stylesheet" type="text/css" />
    <link href="layouts/modern-dark-menu/css/dark/loader.css" rel="stylesheet" type="text/css" />
    <script src="layouts/modern-dark-menu/loader.js"></script>
    <!-- BEGIN GLOBAL MANDATORY STYLES -->
    <link href="https://fonts.googleapis.com/css?family=Nunito:400,600,700" rel="stylesheet">
    <link href="src/bootstrap/css/bootstrap.min.css" rel="stylesheet" type="text/css" />
    
    <link href="layouts/modern-dark-menu/css/light/plugins.css" rel="stylesheet" type="text/css" />
    <link href="src/assets/css/light/authentication/auth-boxed.css" rel="stylesheet" type="text/css" />
    
    <link href="layouts/modern-dark-menu/css/dark/plugins.css" rel="stylesheet" type="text/css" />
    <link href="src/assets/css/dark/authentication/auth-boxed.css" rel="stylesheet" type="text/css" />
    <!-- END GLOBAL MANDATORY STYLES -->
    
</head>
<body class="form">

    <!-- BEGIN LOADER -->
    <div id="load_screen"> <div class="loader"> <div class="loader-content">
        <div class="spinner-grow align-self-center"></div>
    </div></div></div>
    <!--  END LOADER -->

    <div class="auth-container d-flex">

        <div class="container mx-auto align-self-center">
    
            <div class="row">
    
                <div class="col-xxl-4 col-xl-5 col-lg-5 col-md-8 col-12 d-flex flex-column align-self-center mx-auto">
                    <div class="card mt-3 mb-3">
                        <div class="card-body">
    
                            <div class="row">
                                <div class="col-md-12 mb-3">
                                    
                                    <h2>Sign In HexaDash</h2>
                                    <p>Enter your email and password to login</p>
                                    
                                </div>
                                <div class="col-md-12">
                                    <div class="mb-3">
                                        <label class="form-label">Email</label>
                                        <input type="email" id="email" placeholder="name@example.com" class="form-control">
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="mb-4">
                                        <label class="form-label">Password</label>
                                        <input name="password" placeholder="Password" id="password" type="password" class="form-control">
                                    </div>
                                </div>
                                
                                <div class="col-12">
                                    <div class="mb-4">
                                        <button id="sign_in" class="btn btn-secondary w-100 signIn-createBtn">SIGN IN</button>
                                    </div>
                                </div>
                                

                            </div>
                            
                        </div>
                    </div>
                </div>
                
            </div>
            
        </div>

    </div>
    
    <!-- BEGIN GLOBAL MANDATORY SCRIPTS -->
<script src="src/bootstrap/js/bootstrap.bundle.min.js"></script>
    <!-- END GLOBAL MANDATORY SCRIPTS -->
  <!-- jQuery (load before using $) -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<link rel="stylesheet" href="//cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.css">
<script src="//cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>


  <script>
    $(document).ready(function(){
      $('#sign_in').click(function()
      {
        var email = $('#email').val();
        var password = $('#password').val();

        if(email == '')
        {
          toastr.error('Email not mentioned.');
        }
        else if(password == '')
        {
          toastr.error('Password not mentioned.');
        }
        else
        {
          var fd = new FormData();

          fd.append('email', email);
          fd.append('password', password);

          $.ajax({
            url: "<?php echo $main_path; ?>ajax/auth/login.php",
            data: fd,
            contentType: false,
            processData: false,
            type: "post",
            success: function(response) 
            {
              console.log(response);
              var result = JSON.parse(response);

              if (result.status == 'Success') 
              {
                toastr.success('Logged in successfully');
                if(result.role == 'Admin')
                {
                  window.location.href = '<?php echo $admin_path; ?>Dashboard';
                }
                else
                {
                  toastr.error('User not found.');  
                }                
              } 
              else if(result.status == 'No-Access') 
              {
                toastr.error('Your Login is available.');
              }
              else if(result.status == 'Failed') 
              {
                toastr.error('User not Found.');
              }
            }
          });
        }
      })
    })
  </script> 


</body>

</html>